function [p] = runfindQT_avg(filename,start,stop,channel,freq)
% runfindQT(V_on, V_off)
%
% Input Variables
%   V_on -
%   V_off -
%
% Output Variables
%   Q -
%   T -
%
% Description
%   Plots these ECGs.

% Created
%   4/23/2006, Richard J. Povinelli, Marquette University
% Modified
%   Mohamed A Mneimneh, Marquette University
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).



[signal] = get_Beat(filename,start,stop,channel);



[p] = findQT(signal,freq);
t = start:stop;
t = t.*1e-3;

[ecg RVepInt RVenInt LVepInt LVenInt] = ecgGen(t,p,debug)

iall = sort([RVepInt RVenInt LVepInt LVenInt]);
iall1 = all(find(all~=1));
clear iall;
iall = iall1;

if ~isempty(all)
    Q_on = iall(3);
    T_off = iall(end-1);
    QT = T_off - Q_on;
else
    'Unable to detect QT signal'
end
